/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;

public class DownloadStatusMonitor
extends OiimDownloadProgressStatusHolder {
    private Condition condition;
    private ReentrantLock lock;
    long downloadedSize;
    private Logger logger = Logger.getLogger(DownloadStatusMonitor.class.getName());

    public DownloadStatusMonitor(ReentrantLock lock, Condition condition, long downloadedSize) {
        this.condition = condition;
        this.lock = lock;
        this.downloadedSize = downloadedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int sts) {
        super.setStatus(sts);
        if (sts == 3 || sts == 4) {
            try {
                if (this.condition != null) {
                    this.logger.log(Level.FINEST, "DownloadStatusMonitor:download job completed");
                    this.lock.lock();
                    this.condition.signal();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception occurred while signalling the end of download ", e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setBytesDownloaded(long bytesDownloaded) {
        this.logger.log(Level.FINEST, "DownloadStatusMonitor: Bytes downloaded: " + bytesDownloaded);
        this.downloadedSize = bytesDownloaded;
        super.setBytesDownloaded(bytesDownloaded);
    }
}

